<?php

namespace App\Http\Controllers\Traits;

use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;

trait ImageHandlerTrait
{
    /**
     * Handle the image upload.
     *
     * @param  \Illuminate\Http\UploadedFile  $imageFile
     * @param  string  $path
     * @return string
     */
    private function handleImageUpload($imageFile, $path)
    {
        // Generate a unique name for the image
        $imageName = time() . '-' . $imageFile->getClientOriginalName();
        
        // Define the storage path (public storage)
        $storagePath = 'public/' . $path;

        // Ensure the directory exists
        if (!Storage::exists($storagePath)) {
            Storage::makeDirectory($storagePath, 0775, true);
        }

        // Store the image in the public directory (app/public)
        $imageFile->storeAs($storagePath, $imageName);

        // Return the file path for the uploaded image (relative to the public directory)
        return "$path/$imageName";
    }
}



