@extends('layouts.admin')

@push('styles')
<link rel="stylesheet" href="/admin_resources/vendors/typicons.font/font/typicons.css">
<link rel="stylesheet" href="/admin_resources/vendors/css/vendor.bundle.base.css">
<link rel="stylesheet" href="/admin_resources/css/vertical-layout-light/style.css">
@endpush

@section('title', 'Admin - Dashboard')

@section('content')
<div class="main-panel">
  <div class="content-wrapper">
    <div class="d-flex justify-content-between align-items-center mb-4">
      <h4 class="mb-0">📊 Order Reports</h4>
      <a href="{{ route('admin.orders.index') }}" class="btn btn-secondary btn-sm">← Back to Orders</a>
    </div>

    <div class="row">
      <div class="col-md-12 mb-4">
        <div class="card height="200"">
          <div class="card-header"><strong>Daily Orders (Last 7 Days)</strong></div>
          <div class="card-body"><canvas id="dailyChart" ></canvas></div>
        </div>
      </div>

      <div class="col-md-12 mb-4">
        <div class="card" height="200">
          <div class="card-header"><strong>Weekly Orders (Last 8 Weeks)</strong></div>
          <div class="card-body"><canvas id="weeklyChart" ></canvas></div>
        </div>
      </div>

      <div class="col-md-12 mb-4">
        <div class="card" height="200">
          <div class="card-header"><strong>Monthly Orders (Last 12 Months)</strong></div>
          <div class="card-body"><canvas id="monthlyChart" ></canvas></div>
        </div>
      </div>

      <div class="col-md-12 mb-4">
        <div class="card" height="200">
          <div class="card-header"><strong>Yearly Orders (Last 12 Months)</strong></div>
          <div class="card-body"><canvas id="yearlyChart" ></canvas></div>
        </div>
      </div>
    </div>
  </div>
  @include('partials.admin.footer')
</div>
@endsection

@push('scripts')
<script src="/admin_resources/vendors/chart.js/Chart.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {

    function chartOptions(label) {
        return {
            responsive: true,
            plugins: {
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return '৳ ' + Number(context.raw).toLocaleString();
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return '৳ ' + Number(value).toLocaleString();
                        }
                    }
                }
            }
        };
    }

    // Daily Chart
    const dailyLabels = {!! json_encode($daily->pluck('date')) !!};
    const dailyData = {!! json_encode($daily->pluck('total_sales')) !!};
    new Chart(document.getElementById('dailyChart').getContext('2d'), {
        type: 'bar',
        data: {
            labels: dailyLabels,
            datasets: [{
                label: 'Daily Sales',
                data: dailyData,
                backgroundColor: 'rgba(54, 162, 235, 0.6)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 1
            }]
        },
        options: {
        maintainAspectRatio: true, // or omit, as it's true by default
            aspectRatio: 3, // Example: width will be twice the height
            // ... other options
        }
    });

    // Weekly Chart
    const weeklyLabels = {!! json_encode($weekly->pluck('week')) !!};
    const weeklyData = {!! json_encode($weekly->pluck('total_sales')) !!};
    new Chart(document.getElementById('weeklyChart').getContext('2d'), {
        type: 'line',
        data: {
            labels: weeklyLabels,
            datasets: [{
                label: 'Weekly Sales',
                data: weeklyData,
                borderColor: 'rgba(255, 159, 64, 1)',
                backgroundColor: 'rgba(255, 159, 64, 0.3)',
                fill: true,
                tension: 0.3
            }]
        },
         options: {
        maintainAspectRatio: true, // or omit, as it's true by default
            aspectRatio: 3, // Example: width will be twice the height
            // ... other options
        }
    });

    // Monthly Chart
    const monthlyLabels = {!! json_encode($monthly->pluck('month')) !!};
    const monthlyData = {!! json_encode($monthly->pluck('total_sales')) !!};
    new Chart(document.getElementById('monthlyChart').getContext('2d'), {
        type: 'bar',
        data: {
            labels: monthlyLabels,
            datasets: [{
                label: 'Monthly Sales',
                data: monthlyData,
                backgroundColor: 'rgba(75, 192, 192, 0.6)',
                borderColor: 'rgba(75, 192, 192, 1)',
                borderWidth: 1
            }]
        },
        options: {
        maintainAspectRatio: true, // or omit, as it's true by default
            aspectRatio: 3, // Example: width will be twice the height
            // ... other options
        }
    });

    // Yearly Chart
    const yearlyLabels = {!! json_encode($yearly->pluck('year')) !!};
    const yearlyData = {!! json_encode($yearly->pluck('total_sales')) !!};
    new Chart(document.getElementById('yearlyChart').getContext('2d'), {
        type: 'bar',
        data: {
            labels: yearlyLabels,
            datasets: [{
                label: 'Yearly Sales',
                data: yearlyData,
                backgroundColor: 'rgba(153, 102, 255, 0.6)',
                borderColor: 'rgba(153, 102, 255, 1)',
                borderWidth: 1
            }]
        },
         options: {
        maintainAspectRatio: true, // or omit, as it's true by default
            aspectRatio: 3, // Example: width will be twice the height
            // ... other options
        }
    });

});
</script>
@endpush
