@extends('layouts.admin')

@section('title', 'Admin - Order Reports')

@push('styles')
<link rel="stylesheet" href="/admin_resources/vendors/css/vendor.bundle.base.css">
<link rel="stylesheet" href="/admin_resources/css/vertical-layout-light/style.css">

<style>
    /* Cards at the top */
    .report-card {
        border-radius: 12px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        transition: transform 0.2s;
    }
    .report-card:hover {
        transform: translateY(-5px);
    }
    .report-card .inner h3 {
        font-size: 2rem;
        font-weight: 700;
    }

    /* Table styling */
    .report-table {
        border-radius: 8px;
        overflow: hidden;
    }
    .report-table thead {
        background-color: #4e73df;
        color: #fff;
    }
    .report-table tfoot {
        background-color: #f8f9fc;
        font-weight: 600;
    }
    .report-table tbody tr:hover {
        background-color: #f1f3f7;
    }

    /* Report heading */
    .report-heading h4 {
        font-weight: 600;
        color: #2e2e2e;
    }

    /* Filter form spacing */
    .filter-form .form-control {
        border-radius: 8px;
    }
    .filter-form button, .filter-form a.btn {
        border-radius: 8px;
    }
</style>
@endpush

@section('content')
<div class="main-panel">
    <div class="content-wrapper">

        <!-- Top Summary Cards -->
        <div class="row mb-4">
            @php
                $cardBg = ['weekly' => 'bg-info', 'monthly' => 'bg-success', 'yearly' => 'bg-warning'];
            @endphp

            <!-- Weekly -->
            <div class="col-lg-4 col-12 mb-3">
                <div class="small-box report-card {{ $cardBg['weekly'] }} p-3">
                    <div class="inner text-white">
                        <h3>{{ $weeklySalesCount }}</h3>
                        <p>Weekly Orders</p>
                    </div>
                    <div class="icon text-white">
                        <i class="ion ion-ios-calendar"></i>
                    </div>
                    <a href="{{ route('order.report', ['filter' => 'weekly']) }}" class="small-box-footer text-white fw-bold">
                        View <i class="fas fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <!-- Monthly -->
            <div class="col-lg-4 col-12 mb-3">
                <div class="small-box report-card {{ $cardBg['monthly'] }} p-3">
                    <div class="inner text-white">
                        <h3>{{ $monthlySalesCount }}</h3>
                        <p>Monthly Orders</p>
                    </div>
                    <div class="icon text-white">
                        <i class="ion ion-ios-calendar-outline"></i>
                    </div>
                    <a href="{{ route('order.report', ['filter' => 'monthly']) }}" class="small-box-footer text-white fw-bold">
                        View <i class="fas fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <!-- Yearly -->
            <div class="col-lg-4 col-12 mb-3">
                <div class="small-box report-card {{ $cardBg['yearly'] }} p-3">
                    <div class="inner text-white">
                        <h3>{{ $yearlySalesCount }}</h3>
                        <p>Yearly Orders</p>
                    </div>
                    <div class="icon text-white">
                        <i class="ion ion-ios-calendar-outline"></i>
                    </div>
                    <a href="{{ route('order.report', ['filter' => 'yearly']) }}" class="small-box-footer text-white fw-bold">
                        View <i class="fas fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Page Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h4 class="mb-0">📊 Order Reports</h4>
            <a href="{{ route('admin.orders.index') }}" class="btn btn-secondary btn-sm">← Back to Orders</a>
        </div>

        <!-- Filter Form -->
        <form method="GET" class="mb-4 filter-form p-3 border rounded bg-white shadow-sm">
            <div class="row g-3">
                <div class="col-md-3">
                    <label class="form-label fw-bold">Start Date</label>
                    <input type="date" name="start_date" class="form-control" value="{{ $start_date }}">
                </div>
                <div class="col-md-3">
                    <label class="form-label fw-bold">End Date</label>
                    <input type="date" name="end_date" class="form-control" value="{{ $end_date }}">
                </div>
                <div class="col-md-3">
                    <label class="form-label fw-bold">Customer</label>
                    <select name="customer_id" class="form-control py-3">
                        <option value="">All Customers</option>
                        @foreach($customers as $customer)
                            <option value="{{ $customer->id }}" {{ $customerId == $customer->id ? 'selected' : '' }}>
                                {{ $customer->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">Search</button>
                    <a href="{{ route('order.report') }}" class="btn btn-secondary ml-2">Reset</a>
                </div>
            </div>
        </form>

        <!-- Report Table -->
        <div class="card shadow-sm">
            <div class="card-body">

                <!-- Report Heading -->
                <div class="mb-3 report-heading">
                    @if(request()->has('start_date') && request()->has('end_date'))
                        <h4>📋 Report from {{ \Carbon\Carbon::parse($start_date)->format('d M, Y') }} to {{ \Carbon\Carbon::parse($end_date)->format('d M, Y') }}</h4>
                   @elseif(request()->filter)
    <h4>📋 {{ ucfirst(request()->filter) }} Report</h4>
                    @else
                        <h4>📋 Today's Report ({{ \Carbon\Carbon::today()->format('d M, Y') }})</h4>
                    @endif
                </div>

                <div class="table-responsive report-table">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Customer Name</th>
                                <th>Item Name</th>
                                <th>Note</th>
                                <th>Quantity</th>
                                <th>Total Sales (৳)</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($reportData as $index => $row)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $row['customer_name'] }}</td>
                                    <td>{{ $row['menu_name'] }}</td>
                                    <td>{{ $row['additional_info'] }}</td>
                                    <td>{{ $row['quantity'] }}</td>
                                    <td>{{ number_format($row['total_sales'], 2) }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="text-center">No orders found for the selected criteria.</td>
                                </tr>
                            @endforelse
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="4" class="text-end">Totals</th>
                                <th>{{ $totalQuantity }}</th>
                                <th>{{ number_format($totalSales, 2) }}</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>

            </div>
        </div>

    </div>
    @include('partials.admin.footer')
</div>
@endsection
