<nav class="navbar navbar-expand-lg">

    <div class="w-100 d-flex align-items-center justify-content-between mt-5">
@php
    use App\Models\SiteSetting;

    $siteSetting = SiteSetting::first();

    $logo = $siteSetting && $siteSetting->image
        ? asset('storage/' . $siteSetting->image)
        : asset('assets/images/logo_light.png'); // fallback
@endphp

        <!-- LOGO -->
     <!-- LOGO -->
<a class="navbar-brand" href="{{ route('home') }}">
    <img class="logo_light" src="{{ $logo }}" alt="logo">
    <img class="logo_dark" src="{{ $logo }}" alt="logo">
</a>


        <!-- MENU (CENTER) -->
        <div class="menu-wrapper">
            <div class="collapse navbar-collapse show" id="navbarSupportedContent">
                <ul class="navbar-nav menu-red">
                    <li><a href="{{ route('home') }}" class="nav-link {{ Request::routeIs('home') ? 'active' : '' }}">Home</a></li>
                    <li><a href="{{ route('menu') }}" class="nav-link {{ Request::is('menu*') ? 'active' : '' }}">Menu</a></li>
                    <li><a href="{{ route('blogs') }}" class="nav-link {{ Request::is('blog*') ? 'active' : '' }}">Blogs</a></li>
                    <li><a href="{{ route('about') }}" class="nav-link {{ Request::routeIs('about') ? 'active' : '' }}">About</a></li>
                    <li><a href="{{ route('contact') }}" class="nav-link {{ Request::routeIs('contact') ? 'active' : '' }}">Contact</a></li>
                </ul>
            </div>
        </div>

        <!-- RIGHT SIDE -->
        <div class="d-flex align-items-center header-right">

            <!-- Call Section -->
            <div class="header_btn call-box d-flex align-items-center">
                <a href="tel:01941829332" class="call-icon">
                    <i class="fa fa-phone"></i>
                </a>
                @php
                    $phone = \App\Models\RestaurantPhoneNumber::first();
                    $firstRestaurantPhoneNumber = $phone ? $phone->phone_number : null;
                @endphp
                @if($firstRestaurantPhoneNumber)
                 <div class="call-text">
                    <h5>CALL & ORDER IN</h5>
                    <h1>{{ $firstRestaurantPhoneNumber }}</h1>
                </div>
                @endif
               
            </div>

            <!-- Divider -->
           

            <!-- Icons -->
            <div class="header-icons d-flex align-items-center">
            <a href="#" class="icon-btn">
                    <i class="fa fa-search"></i>
                </a>
                <a href="{{ route('customer.cart') }}" class="icon-btn">
                    <i class="linearicons-cart"></i>
                    <span class="cart_count">{{ $customer_total_cart_items }}</span>
                </a>
            </div>

        </div>

        <!-- Mobile Toggle -->
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent">
            <span class="ion-android-menu"></span>
        </button>

    </div>
</nav>
