<?php $__env->startPush('styles'); ?>
    <!-- base:css -->
    <link rel="stylesheet" href="/admin_resources/vendors/typicons.font/font/typicons.css">
    <link rel="stylesheet" href="/admin_resources/vendors/css/vendor.bundle.base.css">
    <link rel="stylesheet" href="/admin_resources/css/vertical-layout-light/style.css">
    
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
 
<script src="/admin_resources/vendors/js/vendor.bundle.base.js"></script>
<script src="/admin_resources/js/off-canvas.js"></script>
<script src="/admin_resources/js/hoverable-collapse.js"></script>
<script src="/admin_resources/js/template.js"></script>
<script src="/admin_resources/js/settings.js"></script>
<script src="/admin_resources/js/todolist.js"></script>
<!-- plugin js for this page -->
<script src="/admin_resources/vendors/progressbar.js/progressbar.min.js"></script>
<script src="/admin_resources/vendors/chart.js/Chart.min.js"></script>
<!-- Custom js for this page-->
<script src="/admin_resources/js/dashboard.js"></script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>


<script>

    function editUser(button) {

        let user = $(button).data(); // Extract all data-* attributes into an object

        let actionUrl = "<?php echo e(route('admin.users.update', ':id')); ?>".replace(':id', user.id);
        $('#editUserForm').attr('action', actionUrl);

        $('#editFirstName').val(user.firstName);  
        $('#editMiddleName').val(user.middleName || '');  
        $('#editLastName').val(user.lastName);
        $('#editEmail').val(user.email);
        $('#editRole').val(user.role);

        if (user.notice === 'change_password_to_activate_account') {
            $('#banCheckboxDiv').hide();
        } else {
         
            $('#banCheckboxDiv').show();
            $('#banCheckbox').prop('checked', user.status === 0); 
        }
    }


    // Attach event listener to the modal
    $('#viewUserModal').on('show.bs.modal', function (event) {
        // Button that triggered the modal
        var button = $(event.relatedTarget);

        // Extract data from the button's data-* attributes
        var first_name = button.data('first_name');
        var middle_name = button.data('middle_name');
        var last_name = button.data('last_name');
        var email = button.data('email');
        var role = button.data('role');
        var status = button.data('status');
        var phoneNumber = button.data('phone-number');
        var address = button.data('address');
        var profilePicture = button.data('profile-picture');

        // Update the modal content
        var modal = $(this);
        modal.find('#viewProfilePicture').attr('src', profilePicture || "<?php echo e(asset('assets/images/user-icon.png')); ?>");
        modal.find('#viewFirstName').text(first_name);
        modal.find('#viewMiddleName').text(middle_name);
        modal.find('#viewLastName').text(last_name);
        modal.find('#viewEmail').text(email);
        modal.find('#viewRole').text(role);
        modal.find('#viewStatus').html(status === 1 
            ? '<span class="badge bg-success"><i class="fa fa-check"></i> Active</span>' 
            : '<span class="badge bg-danger"><i class="fa fa-exclamation"></i> Banned</span>');
        modal.find('#viewPhoneNumber').text(phoneNumber || 'N/A');
        modal.find('#viewAddress').text(address || 'N/A');
    });

</script>
 
<?php $__env->stopPush(); ?>


<?php $__env->startSection('title', 'Admin - Manage Users'); ?>




<?php $__env->startSection('content'); ?>

<div class="main-panel">
    <div class="content-wrapper">
 
      <?php echo $__env->make('partials.message-bag', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
 
      <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span>Manage Admin (<?php echo e($users->count()); ?>)</span>
            <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#createUserModal">Add Admin</button>
        </div>
        <div class="card-body">
            <?php if($users->isEmpty()): ?>
                <div class="alert alert-warning" role="alert">
                    No admin records found.
                </div>
            <?php else: ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Role</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><i class='fa fa-user'></i>&nbsp; <?php echo e($user->first_name); ?>  <?php echo e($user->middle_name ? $user->middle_name . ' ' : ''); ?>  <?php echo e($user->last_name); ?></td>
                                
                                <td><?php echo e($user->email); ?></td>
                                <td><?php echo e(ucwords(str_replace('_', ' ', $user->role))); ?></td>
                                <td>
                                    <?php if($user->status === 1): ?>
                                        <span class="badge bg-success"><i class="fa fa-check"></i></span>
                                    <?php else: ?>
                                        <span class="badge bg-danger"><i class="fas fa-exclamation-triangle"></i></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <button 
                                    class="btn btn-primary btn-sm" 
                                    data-bs-toggle="modal" 
                                    data-bs-target="#viewUserModal" 
                                    data-first_name="<?php echo e($user->first_name); ?>" 
                                    data-middle_name="<?php echo e($user->middle_name); ?>" 
                                    data-last_name="<?php echo e($user->last_name); ?>"
                                    data-email="<?php echo e($user->email); ?>"
                                    data-role="<?php echo e(ucwords(str_replace('_', ' ', $user->role))); ?>"
                                    data-status="<?php echo e($user->status); ?>"
                                    data-phone-number="<?php echo e($user->phone_number); ?>"
                                    data-address="<?php echo e($user->address); ?>"
                                    data-profile-picture="<?php echo e($user->profile_picture ? asset('storage/profile-picture/' . $user->profile_picture) : asset('assets/images/user-icon.png')); ?>"
                                    > <i class="fa fa-eye"></i>  </button>

                                    <button 
                                    class="btn btn-warning btn-sm" 
                                    data-bs-toggle="modal" 
                                    data-bs-target="#editUserModal"
                                    data-id="<?php echo e($user->id); ?>"
                                    data-first-name="<?php echo e($user->first_name); ?>"
                                    data-middle-name="<?php echo e($user->middle_name); ?>"
                                    data-last-name="<?php echo e($user->last_name); ?>"
                                    data-email="<?php echo e($user->email); ?>"
                                    data-role="<?php echo e($user->role); ?>"
                                    data-status="<?php echo e($user->status); ?>"
                                    data-notice="<?php echo e($user->notice); ?>"
                                    onclick="editUser(this)">
                                    <i class='fa fa-edit'></i>
                                    </button>
                                                           
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>                    
                </table>
            <?php endif; ?>
        </div>
    </div>
    
   
 











<!-- Create User Modal -->
<div class="modal fade" id="createUserModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="<?php echo e(route('admin.users.store')); ?>">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title">Create Admin</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-danger" role="alert">
                        <i class="fa fa-exclamation-triangle"></i> The password will be the user's email address. The user should log in with this credential and change their password to gain access to the admin panel.
                    </div>
                    <div class="mb-3">
                        <label>First Name</label>
                        <input type="text" name="first_name" id="FirstName" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Middle Name</label>
                        <input type="text" name="middle_name" id="MiddleName" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label>Last Name</label>
                        <input type="text" name="last_name" id="LastName" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Email</label>
                        <input type="email" name="email" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Role</label>
                        <select name="role" class="form-control form-control-sm" required>
                            <option value="admin">Admin</option>
                            <option value="global_admin">Global Admin</option>
                        </select>
                    </div>
                    
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Create</button>
                </div>
            </form>
        </div>
    </div>
</div>




<!-- Edit User Modal -->
<div class="modal fade" id="editUserModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" id="editUserForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-header">
                    <h5 class="modal-title">Edit User</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label>First Name</label>
                        <input type="text" name="first_name" id="editFirstName" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Middle Name</label>
                        <input type="text" name="middle_name" id="editMiddleName" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label>Last Name</label>
                        <input type="text" name="last_name" id="editLastName" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Email</label>
                        <input type="email" name="email" id="editEmail" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Role</label>
                        <select name="role" id="editRole" class="form-control form-control-sm form-select" required>
                            <option value="admin">Admin</option>
                            <option value="global_admin">Global Admin</option>
                        </select>
                    </div>
                    <div class="form-check form-check-flat form-check-primary" id="banCheckboxDiv">
                        <label class="form-check-label" for="banCheckbox">
                            <input type="checkbox" class="form-check-input" id="banCheckbox" name="ban"> Ban User
                            <i class="input-helper"></i>
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>





<div class="modal fade" id="viewUserModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">View User Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="text-center mb-3">
                    <!-- Profile Image -->
                    <img id="viewProfilePicture" src="<?php echo e(asset('assets/images/user-icon.png')); ?>" 
                         alt="Profile Image" 
                         class="img-thumbnail" 
                         style="width: 100px; height: 100px;">
                </div>
                <table class="table table-bordered">
                    <tr>
                        <th>First Name</th>
                        <td id="viewFirstName"></td>
                    </tr>
                    <tr>
                        <th>Middle Name</th>
                        <td id="viewMiddleName"></td>
                    </tr>
                    <tr>
                        <th>Last Name</th>
                        <td id="viewLastName"></td>
                    </tr>                    
                    <tr>
                        <th>Email</th>
                        <td id="viewEmail"></td>
                    </tr>
                    <tr>
                        <th>Role</th>
                        <td id="viewRole"></td>
                    </tr>
                    <tr>
                        <th>Status</th>
                        <td id="viewStatus"></td>
                    </tr>
                    <tr>
                        <th>Phone Number</th>
                        <td id="viewPhoneNumber"></td>
                    </tr>
                    <tr>
                        <th>Address</th>
                        <td id="viewAddress"></td>
                    </tr>

                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>






   
    </div>
    <!-- content-wrapper ends -->
    <?php echo $__env->make('partials.admin.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  </div>
  <!-- main-panel ends -->
<?php $__env->stopSection(); ?>



 
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/tech3/public_html/demo/restaurant/resources/views/admin/manage-users.blade.php ENDPATH**/ ?>