<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="/admin_resources/vendors/typicons.font/font/typicons.css">
<link rel="stylesheet" href="/admin_resources/vendors/css/vendor.bundle.base.css">
<link rel="stylesheet" href="/admin_resources/css/vertical-layout-light/style.css">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('title', 'Admin - Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="main-panel">
  <div class="content-wrapper">
    <div class="d-flex justify-content-between align-items-center mb-4">
      <h4 class="mb-0">📊 Order Reports</h4>
      <a href="<?php echo e(route('admin.orders.index')); ?>" class="btn btn-secondary btn-sm">← Back to Orders</a>
    </div>

    <div class="row">
      <div class="col-md-12 mb-4">
        <div class="card height="200"">
          <div class="card-header"><strong>Daily Orders (Last 7 Days)</strong></div>
          <div class="card-body"><canvas id="dailyChart" ></canvas></div>
        </div>
      </div>

      <div class="col-md-12 mb-4">
        <div class="card" height="200">
          <div class="card-header"><strong>Weekly Orders (Last 8 Weeks)</strong></div>
          <div class="card-body"><canvas id="weeklyChart" ></canvas></div>
        </div>
      </div>

      <div class="col-md-12 mb-4">
        <div class="card" height="200">
          <div class="card-header"><strong>Monthly Orders (Last 12 Months)</strong></div>
          <div class="card-body"><canvas id="monthlyChart" ></canvas></div>
        </div>
      </div>

      <div class="col-md-12 mb-4">
        <div class="card" height="200">
          <div class="card-header"><strong>Yearly Orders (Last 12 Months)</strong></div>
          <div class="card-body"><canvas id="yearlyChart" ></canvas></div>
        </div>
      </div>
    </div>
  </div>
  <?php echo $__env->make('partials.admin.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="/admin_resources/vendors/chart.js/Chart.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {

    function chartOptions(label) {
        return {
            responsive: true,
            plugins: {
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return '৳ ' + Number(context.raw).toLocaleString();
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return '৳ ' + Number(value).toLocaleString();
                        }
                    }
                }
            }
        };
    }

    // Daily Chart
    const dailyLabels = <?php echo json_encode($daily->pluck('date')); ?>;
    const dailyData = <?php echo json_encode($daily->pluck('total_sales')); ?>;
    new Chart(document.getElementById('dailyChart').getContext('2d'), {
        type: 'bar',
        data: {
            labels: dailyLabels,
            datasets: [{
                label: 'Daily Sales',
                data: dailyData,
                backgroundColor: 'rgba(54, 162, 235, 0.6)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 1
            }]
        },
        options: {
        maintainAspectRatio: true, // or omit, as it's true by default
            aspectRatio: 3, // Example: width will be twice the height
            // ... other options
        }
    });

    // Weekly Chart
    const weeklyLabels = <?php echo json_encode($weekly->pluck('week')); ?>;
    const weeklyData = <?php echo json_encode($weekly->pluck('total_sales')); ?>;
    new Chart(document.getElementById('weeklyChart').getContext('2d'), {
        type: 'line',
        data: {
            labels: weeklyLabels,
            datasets: [{
                label: 'Weekly Sales',
                data: weeklyData,
                borderColor: 'rgba(255, 159, 64, 1)',
                backgroundColor: 'rgba(255, 159, 64, 0.3)',
                fill: true,
                tension: 0.3
            }]
        },
         options: {
        maintainAspectRatio: true, // or omit, as it's true by default
            aspectRatio: 3, // Example: width will be twice the height
            // ... other options
        }
    });

    // Monthly Chart
    const monthlyLabels = <?php echo json_encode($monthly->pluck('month')); ?>;
    const monthlyData = <?php echo json_encode($monthly->pluck('total_sales')); ?>;
    new Chart(document.getElementById('monthlyChart').getContext('2d'), {
        type: 'bar',
        data: {
            labels: monthlyLabels,
            datasets: [{
                label: 'Monthly Sales',
                data: monthlyData,
                backgroundColor: 'rgba(75, 192, 192, 0.6)',
                borderColor: 'rgba(75, 192, 192, 1)',
                borderWidth: 1
            }]
        },
        options: {
        maintainAspectRatio: true, // or omit, as it's true by default
            aspectRatio: 3, // Example: width will be twice the height
            // ... other options
        }
    });

    // Yearly Chart
    const yearlyLabels = <?php echo json_encode($yearly->pluck('year')); ?>;
    const yearlyData = <?php echo json_encode($yearly->pluck('total_sales')); ?>;
    new Chart(document.getElementById('yearlyChart').getContext('2d'), {
        type: 'bar',
        data: {
            labels: yearlyLabels,
            datasets: [{
                label: 'Yearly Sales',
                data: yearlyData,
                backgroundColor: 'rgba(153, 102, 255, 0.6)',
                borderColor: 'rgba(153, 102, 255, 1)',
                borderWidth: 1
            }]
        },
         options: {
        maintainAspectRatio: true, // or omit, as it's true by default
            aspectRatio: 3, // Example: width will be twice the height
            // ... other options
        }
    });

});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\EnamulHaque\restaurant\resources\views/admin/index.blade.php ENDPATH**/ ?>