

<?php $__env->startSection('title', 'Admin - Order Reports'); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="/admin_resources/vendors/css/vendor.bundle.base.css">
<link rel="stylesheet" href="/admin_resources/css/vertical-layout-light/style.css">

<style>
    /* Cards at the top */
    .report-card {
        border-radius: 12px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        transition: transform 0.2s;
    }
    .report-card:hover {
        transform: translateY(-5px);
    }
    .report-card .inner h3 {
        font-size: 2rem;
        font-weight: 700;
    }

    /* Table styling */
    .report-table {
        border-radius: 8px;
        overflow: hidden;
    }
    .report-table thead {
        background-color: #4e73df;
        color: #fff;
    }
    .report-table tfoot {
        background-color: #f8f9fc;
        font-weight: 600;
    }
    .report-table tbody tr:hover {
        background-color: #f1f3f7;
    }

    /* Report heading */
    .report-heading h4 {
        font-weight: 600;
        color: #2e2e2e;
    }

    /* Filter form spacing */
    .filter-form .form-control {
        border-radius: 8px;
    }
    .filter-form button, .filter-form a.btn {
        border-radius: 8px;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="main-panel">
    <div class="content-wrapper">

        <!-- Top Summary Cards -->
        <div class="row mb-4">
            <?php
                $cardBg = ['weekly' => 'bg-info', 'monthly' => 'bg-success', 'yearly' => 'bg-warning'];
            ?>

            <!-- Weekly -->
            <div class="col-lg-4 col-12 mb-3">
                <div class="small-box report-card <?php echo e($cardBg['weekly']); ?> p-3">
                    <div class="inner text-white">
                        <h3><?php echo e($weeklySalesCount); ?></h3>
                        <p>Weekly Orders</p>
                    </div>
                    <div class="icon text-white">
                        <i class="ion ion-ios-calendar"></i>
                    </div>
                    <a href="<?php echo e(route('order.report', ['filter' => 'weekly'])); ?>" class="small-box-footer text-white fw-bold">
                        View <i class="fas fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <!-- Monthly -->
            <div class="col-lg-4 col-12 mb-3">
                <div class="small-box report-card <?php echo e($cardBg['monthly']); ?> p-3">
                    <div class="inner text-white">
                        <h3><?php echo e($monthlySalesCount); ?></h3>
                        <p>Monthly Orders</p>
                    </div>
                    <div class="icon text-white">
                        <i class="ion ion-ios-calendar-outline"></i>
                    </div>
                    <a href="<?php echo e(route('order.report', ['filter' => 'monthly'])); ?>" class="small-box-footer text-white fw-bold">
                        View <i class="fas fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <!-- Yearly -->
            <div class="col-lg-4 col-12 mb-3">
                <div class="small-box report-card <?php echo e($cardBg['yearly']); ?> p-3">
                    <div class="inner text-white">
                        <h3><?php echo e($yearlySalesCount); ?></h3>
                        <p>Yearly Orders</p>
                    </div>
                    <div class="icon text-white">
                        <i class="ion ion-ios-calendar-outline"></i>
                    </div>
                    <a href="<?php echo e(route('order.report', ['filter' => 'yearly'])); ?>" class="small-box-footer text-white fw-bold">
                        View <i class="fas fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Page Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h4 class="mb-0">📊 Order Reports</h4>
            <a href="<?php echo e(route('admin.orders.index')); ?>" class="btn btn-secondary btn-sm">← Back to Orders</a>
        </div>

        <!-- Filter Form -->
        <form method="GET" class="mb-4 filter-form p-3 border rounded bg-white shadow-sm">
            <div class="row g-3">
                <div class="col-md-3">
                    <label class="form-label fw-bold">Start Date</label>
                    <input type="date" name="start_date" class="form-control" value="<?php echo e($start_date); ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label fw-bold">End Date</label>
                    <input type="date" name="end_date" class="form-control" value="<?php echo e($end_date); ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label fw-bold">Customer</label>
                    <select name="customer_id" class="form-control py-3">
                        <option value="">All Customers</option>
                        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($customer->id); ?>" <?php echo e($customerId == $customer->id ? 'selected' : ''); ?>>
                                <?php echo e($customer->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">Search</button>
                    <a href="<?php echo e(route('order.report')); ?>" class="btn btn-secondary ml-2">Reset</a>
                </div>
            </div>
        </form>

        <!-- Report Table -->
        <div class="card shadow-sm">
            <div class="card-body">

                <!-- Report Heading -->
                <div class="mb-3 report-heading">
                    <?php if(request()->has('start_date') && request()->has('end_date')): ?>
                        <h4>📋 Report from <?php echo e(\Carbon\Carbon::parse($start_date)->format('d M, Y')); ?> to <?php echo e(\Carbon\Carbon::parse($end_date)->format('d M, Y')); ?></h4>
                   <?php elseif(request()->filter): ?>
    <h4>📋 <?php echo e(ucfirst(request()->filter)); ?> Report</h4>
                    <?php else: ?>
                        <h4>📋 Today's Report (<?php echo e(\Carbon\Carbon::today()->format('d M, Y')); ?>)</h4>
                    <?php endif; ?>
                </div>

                <div class="table-responsive report-table">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Customer Name</th>
                                <th>Menu Name</th>
                                <th>Additional Info</th>
                                <th>Quantity</th>
                                <th>Total Sales (৳)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $reportData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td><?php echo e($row['customer_name']); ?></td>
                                    <td><?php echo e($row['menu_name']); ?></td>
                                    <td><?php echo e($row['additional_info']); ?></td>
                                    <td><?php echo e($row['quantity']); ?></td>
                                    <td><?php echo e(number_format($row['total_sales'], 2)); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center">No orders found for the selected criteria.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="4" class="text-end">Totals</th>
                                <th><?php echo e($totalQuantity); ?></th>
                                <th><?php echo e(number_format($totalSales, 2)); ?></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>

            </div>
        </div>

    </div>
    <?php echo $__env->make('partials.admin.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\EnamulHaque\restaurant\resources\views/admin/report.blade.php ENDPATH**/ ?>