<!DOCTYPE html>
<html lang="en">
  <head>
     <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?php echo $__env->yieldContent('title'); ?></title>

    <?php echo $__env->yieldPushContent('styles'); ?>
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/all.css">

    <!-- endinject -->
    <link rel="shortcut icon" href="/favicon_io/favicon.ico" />
  </head>
  <body>
 
    <div class="container-scroller">
      <!-- partial:partials/_navbar.html -->
      <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
        <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
       <?php
    use App\Models\SiteSetting;

    $siteSetting = SiteSetting::first();

    $logo = $siteSetting && $siteSetting->image
        ? asset('storage/' . $siteSetting->image)
        : asset('assets/images/logo_light.png'); // fallback
?>


          <a class="navbar-brand brand-logo" href="<?php echo e(route('admin.index')); ?>"><img src="<?php echo e($logo); ?>" alt="logo"/></a>
          <a class="navbar-brand brand-logo-mini" href="<?php echo e(route('admin.index')); ?>"><img src="/admin_resources/images/logo-mini.svg" alt="logo"/></a>
          <button class="navbar-toggler navbar-toggler align-self-center d-none d-lg-flex" type="button" data-toggle="minimize">
            <span class="typcn typcn-th-menu"></span>
          </button>
        </div>
        <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end">
 
          <ul class="navbar-nav navbar-nav-right">
            <li class="nav-item d-none d-lg-flex  mr-2">  <a class="nav-link" href="<?php echo e(route('admin.view.myprofile')); ?>"> <i class="typcn typcn-user-outline mr-0"></i> <?php echo e($loggedInUser->first_name); ?>  </a> </li>
            <li class="nav-item d-none d-lg-flex  mr-2">  <a class="nav-link" href="<?php echo e(route('admin.logout')); ?>"> <i class="typcn typcn-power-outline mr-0"></i> Logout  </a> </li>
         
         

          </ul>

          <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
            <span class="typcn typcn-th-menu"></span>
          </button>
        </div>
      </nav>
      <!-- partial -->
      <div class="container-fluid page-body-wrapper">


        <?php echo $__env->make('partials.admin.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        
        <?php echo $__env->yieldContent('content'); ?>

        <?php echo $__env->make('partials.logout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

      </div>
      <!-- page-body-wrapper ends -->
    </div>
    <!-- container-scroller -->
 
    <?php echo $__env->yieldPushContent('scripts'); ?>

 <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

  </body>
</html><?php /**PATH D:\EnamulHaque\restaurant\resources\views/layouts/admin.blade.php ENDPATH**/ ?>