<?php $__env->startPush('styles'); ?>
    <!-- base:css -->
    <link rel="stylesheet" href="/admin_resources/vendors/typicons.font/font/typicons.css">
    <link rel="stylesheet" href="/admin_resources/vendors/css/vendor.bundle.base.css">
    <link rel="stylesheet" href="/admin_resources/css/vertical-layout-light/style.css">
    
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
 
<script src="/admin_resources/vendors/js/vendor.bundle.base.js"></script>
<script src="/admin_resources/js/off-canvas.js"></script>
<script src="/admin_resources/js/hoverable-collapse.js"></script>
<script src="/admin_resources/js/template.js"></script>
<script src="/admin_resources/js/settings.js"></script>
<script src="/admin_resources/js/todolist.js"></script>
<!-- plugin js for this page -->
<script src="/admin_resources/vendors/progressbar.js/progressbar.min.js"></script>
<script src="/admin_resources/vendors/chart.js/Chart.min.js"></script>
<!-- Custom js for this page-->
<script src="/admin_resources/js/dashboard.js"></script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
 

<?php $__env->stopPush(); ?>


<?php $__env->startSection('title', 'Admin - Settings - Categories'); ?>




<?php $__env->startSection('content'); ?>

<div class="main-panel">
    <div class="content-wrapper">
 
      <?php echo $__env->make('partials.message-bag', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
 

      <div class="card card-info">
        <div class="card-header">
            <i class="fa fa-user"></i> My Profile
        </div>
        <div class="card-body">
            <div class="d-flex justify-content-center align-items-center">
                <!-- Profile Photo Preview -->
                <div class="mb-3 text-center">
                    <img src="<?php echo e($user->profile_picture ? asset('storage/profile-picture/' . $user->profile_picture) : asset('assets/images/user-icon.png')); ?>" 
                         alt="Profile Preview" 
                         class="img-thumbnail" 
                         style="width: 150px; height: 150px;">
                </div>
            </div>
            <hr/>
            <table class="table table-bordered">
                <tbody>
                    <tr>
                        <td><b>First Name:</b></td>
                        <td><?php echo e($user->first_name); ?></td>
                    </tr>
                    <tr>
                        <td><b>Middle Name:</b></td>
                        <td><?php echo e($user->middle_name ?? ''); ?></td>
                    </tr>
                    <tr>
                        <td><b>Last Name:</b></td>
                        <td><?php echo e($user->last_name); ?></td>
                    </tr>
                    <tr>
                        <td><b>Email:</b></td>
                        <td><?php echo e($user->email); ?></td>
                    </tr>
                    <tr>
                        <td><b>Role:</b></td>
                        <td><?php echo e(ucwords(str_replace('_', ' ', $user->role))); ?></td>
                    </tr>
                    <tr>
                        <td><b>Phone Number:</b></td>
                        <td><?php echo e($user->phone_number ?? 'N/A'); ?></td>
                    </tr>
                    <tr>
                        <td><b>Address:</b></td>
                        <td><?php echo e($user->address ?? 'N/A'); ?></td>
                    </tr>
                </tbody>
            </table>
            
        </div>
        <div class="card-footer">
            <button type="button" onclick="window.location='<?php echo e(route('admin.myprofile.edit')); ?>'" class="btn btn-info">Edit My Profile</button>
            <button type="button" onclick="window.location='<?php echo e(route('admin.index')); ?>'" class="btn btn-primary float-right">Dashboard</button>
        </div>
    </div>

    
  


   
    </div>
    <!-- content-wrapper ends -->
    <?php echo $__env->make('partials.admin.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  </div>
  <!-- main-panel ends -->
<?php $__env->stopSection(); ?>



 
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/tech3/public_html/demo/restaurant/resources/views/admin/view-my-profile.blade.php ENDPATH**/ ?>