<?php $__env->startPush('styles'); ?>
    <!-- base:css -->
    <link rel="stylesheet" href="/admin_resources/vendors/typicons.font/font/typicons.css">
    <link rel="stylesheet" href="/admin_resources/vendors/css/vendor.bundle.base.css">
    <link rel="stylesheet" href="/admin_resources/css/vertical-layout-light/style.css">
    
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
 
<script src="/admin_resources/vendors/js/vendor.bundle.base.js"></script>
<script src="/admin_resources/js/off-canvas.js"></script>
<script src="/admin_resources/js/hoverable-collapse.js"></script>
<script src="/admin_resources/js/template.js"></script>
<script src="/admin_resources/js/settings.js"></script>
<script src="/admin_resources/js/todolist.js"></script>
<!-- plugin js for this page -->
<script src="/admin_resources/vendors/progressbar.js/progressbar.min.js"></script>
<script src="/admin_resources/vendors/chart.js/Chart.min.js"></script>
<!-- Custom js for this page-->
<script src="/admin_resources/js/dashboard.js"></script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
 


<script type="text/javascript">
    // Preview the selected image (Profile Photo)
    function previewImage() {
        var file = document.getElementById('profile_photo').files[0];
        var reader = new FileReader();
        reader.onloadend = function () {
            document.getElementById('profile_preview').src = reader.result;
        };
        if (file) {
            reader.readAsDataURL(file);
        }
    }
</script>

<?php $__env->stopPush(); ?>


<?php $__env->startSection('title', 'Admin - Edit Profile'); ?>




<?php $__env->startSection('content'); ?>

<div class="main-panel">
    <div class="content-wrapper">
 
      <?php echo $__env->make('partials.message-bag', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

   
      <form action="<?php echo e(route('admin.myprofile.update')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
    
        <div class="card">
            <div class="card-header bg-info text-white">
                <i class="fa fa-user"></i>&nbsp; Edit Profile
            </div>
            <div class="card-body">
                <div class="card-body d-flex justify-content-center align-items-center">
                    <!-- Profile Photo Preview -->
                    <div class="mb-3 text-center">
                        <label for="profile_preview">Preview</label><br>
                        <img id="profile_preview" 
                             src="<?php echo e($user->profile_picture ? asset('storage/profile-picture/' . $user->profile_picture) : asset('assets/images/user-icon.png')); ?>" 
                             alt="Profile Preview" 
                             class="img-thumbnail" 
                             style="width: 150px; height: 150px;">
                        <br/>
                        <label for="profile_photo">Profile Photo</label>
                        <input type="file" class="form-control-file" id="profile_photo" name="profile_photo" style="padding:5px; border: 1px solid black;" accept="image/*" onchange="previewImage()">
                    </div>
                </div>
    
                <hr/>
                <table class="table table-bordered">
                    <tbody>
                        <!-- Name -->
                        <tr>
                            <td><label for="first_name">First Name</label></td>
                            <td><input type="text" class="form-control" id="first_name" name="first_name" value="<?php echo e(old('first_name', $user->first_name)); ?>" required></td>
                        </tr>
                        <tr>
                            <td><label for="middle_name">Middle Name</label></td>
                            <td><input type="text" class="form-control" id="middle_name" name="middle_name" value="<?php echo e(old('middle_name', $user->middle_name)); ?>"></td>
                        </tr>
                        <tr>
                            <td><label for="last_name">Last Name</label></td>
                            <td><input type="text" class="form-control" id="last_name" name="last_name" value="<?php echo e(old('last_name', $user->last_name)); ?>" required></td>
                        </tr>
                        
                        <!-- Email -->
                        <tr>
                            <td><label for="email">Email</label></td>
                            <td><input type="email" class="form-control" id="email" name="email" value="<?php echo e(old('email', $user->email)); ?>" required></td>
                        </tr>
                        <!-- Phone Number -->
                        <tr>
                            <td><label for="phone_number">Phone Number</label></td>
                            <td><input type="text" class="form-control" id="phone_number" name="phone_number" value="<?php echo e(old('phone_number', $user->phone_number)); ?>"></td>
                        </tr>
                        <!-- Address -->
                        <tr>
                            <td><label for="address">Address</label></td>
                            <td><input type="text" class="form-control" id="address" name="address" value="<?php echo e(old('address', $user->address)); ?>"></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="card-footer">
                <button type="submit" class="btn btn-success">Update Profile</button>
                <button type="button" onclick="window.location='<?php echo e(route('admin.view.myprofile')); ?>'" class="btn btn-danger float-right">Back</button>
            </div>
        </div>
    </form> 


   
    </div>
    <!-- content-wrapper ends -->
    <?php echo $__env->make('partials.admin.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  </div>
  <!-- main-panel ends -->
<?php $__env->stopSection(); ?>



 
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\EnamulHaque\restaurant\resources\views/admin/edit-my-profile.blade.php ENDPATH**/ ?>